/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.config;

import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigRootNode;
import filenet.vw.toolkit.design.canvas.config.VWDesignerRegionNode;
import filenet.vw.toolkit.design.canvas.config.VWDesignerVWServiceNode;
import filenet.vw.toolkit.utils.VWSessionInfo;

public class VWDesignerRootNode
extends VWConfigRootNode {
    private VWDesignerCoreData m_designerCoreData = null;

    public VWDesignerRootNode(String baseURL, VWDesignerCoreData designerCoreData) {
        super(baseURL);
        this.m_designerCoreData = designerCoreData;
    }

    public void refresh() {
        try {
            int rootChildCount = this.getChildCount();
            for (int j = rootChildCount - 1; j >= 0; --j) {
                VWDesignerVWServiceNode serviceNode = (VWDesignerVWServiceNode)this.getChildAt(j);
                if (serviceNode.getChildCount() <= 0) {
                    this.remove(j);
                }
                serviceNode.refresh();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setupIsolatedRegions(VWSessionInfo sessionInfo) {
        try {
            String cpName = sessionInfo.getSession().getConnectionPointName();
            int nRegion = sessionInfo.getSession().getIsolatedRegion();
            String nodeName = cpName + " [" + nRegion + "]";
            VWDesignerRegionNode isolatedRegion = new VWDesignerRegionNode(nodeName, this.m_designerCoreData);
            VWDesignerVWServiceNode serviceNode = new VWDesignerVWServiceNode("temp");
            this.add(serviceNode);
            serviceNode.add(isolatedRegion);
            isolatedRegion.logon(this.m_designerCoreData.getSessionInfo());
            serviceNode.setName(isolatedRegion.getServiceName());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            VWDesignerVWServiceNode serviceNode = (VWDesignerVWServiceNode)this.getChildAt(i);
            if (!serviceNode.isDirty()) continue;
            return true;
        }
        return false;
    }
}

